import sys
import os
from Crypto.Cipher import AES

def pkcs7_pad(data: bytes) -> bytes:
    pad_len = 16 - (len(data) % 16)
    return data + bytes([pad_len] * pad_len)

def encrypt_aes_128_cbc(input_file, output_file, key, iv):
    with open(input_file, "rb") as f:
        data = f.read()
    padded_data = pkcs7_pad(data)
    cipher = AES.new(key, AES.MODE_CBC, iv)
    encrypted = cipher.encrypt(padded_data)
    with open(output_file, "wb") as f:
        f.write(encrypted)

if len(sys.argv) != 2:
    print(f"Użycie: {sys.argv[0]} <plik_wejściowy>")
    sys.exit(1)

input_file = sys.argv[1]
if not os.path.isfile(input_file):
    print(f"Plik '{input_file}' nie istnieje.")
    sys.exit(1)

# Klucze jak w oryginale
fw_key_bin = bytes.fromhex(
    '6B333339553443583151235530255E7A76505A414C376C40413734694E536266'
)
iv = fw_key_bin[:16]
key = fw_key_bin[16:]

# Tworzenie nazwy wyjściowej:
base, ext = os.path.splitext(input_file)
base = base.replace("_decrypted", "")  # usunięcie dopisku jeśli jest
output_file = f"{base}_encrypted{ext}"

encrypt_aes_128_cbc(input_file, output_file, key, iv)

print(f"Szyfrowanie zakończone! Plik zapisany jako: {output_file}")

