from Crypto.Cipher import AES
import sys
import os

def pkcs7_unpad(data: bytes) -> bytes:
    pad_len = data[-1]
    if pad_len < 1 or pad_len > 16:
        raise ValueError("Nieprawidłowa długość paddingu")
    if data[-pad_len:] != bytes([pad_len]) * pad_len:
        raise ValueError("Nieprawidłowy padding")
    return data[:-pad_len]

def decrypt_aes_128_cbc(input_file: str, key: bytes, iv: bytes) -> None:
    # Generowanie nazwy pliku wyjściowego
    base, ext = os.path.splitext(input_file)
    output_file = f"{base}_decrypted{ext}"
    
    with open(input_file, "rb") as f:
        data = f.read()
    
    cipher = AES.new(key, AES.MODE_CBC, iv)
    decrypted = cipher.decrypt(data)

    try:
        decrypted = pkcs7_unpad(decrypted)
    except ValueError as e:
        print(f"Błąd paddingu: {e}")
        # Zapis danych bez usuwania paddingu w przypadku błędu
        with open(output_file, "wb") as f:
            f.write(decrypted)
        return

    with open(output_file, "wb") as f:
        f.write(decrypted)
    
    print(f"Deszyfrowanie zakończone! Plik zapisano jako: {output_file}")

if __name__ == "__main__":
    if len(sys.argv) != 2:
        print("Usage: python decrypt.py <encrypted_file>")
        sys.exit(1)
    
    encrypted_file = sys.argv[1]
    
    # Klucz i IV
    fw_key_bin = bytes.fromhex(
        '6B333339553443583151235530255E7A76505A414C376C40413734694E536266'
    )
    iv = fw_key_bin[:16]
    key = fw_key_bin[16:]

    decrypt_aes_128_cbc(encrypted_file, key, iv)
