.SH INCLUDE FILE
#include <mxml.h>
.SH LIBRARY
-lmxml
.SH DESCRIPTION
Mini-XML is a small XML parsing library that you can use to
read XML and XML-like data files in your application without
requiring large non-standard libraries.  Mini-XML only
requires an ANSI C compatible compiler (GCC works, as do
most vendors' ANSI C compilers) and a "make" program.
.PP
Mini-XML provides the following functionality:
.IP \(bu 4
Reading of UTF-8 and UTF-16 and writing of UTF-8 encoded XML files and strings.
.IP \(bu 4
Data is stored in a linked-list tree structure,
preserving the XML data hierarchy.
.IP \(bu 4
Supports arbitrary element names, attributes, and attribute
values with no preset limits, just available memory.
.IP \(bu 4
Supports integer, real, opaque ("cdata"), and text data types in
"leaf" nodes.
.IP \(bu 4
Functions for creating, indexing, and managing trees of data.
.IP \(bu 4
"Find" and "walk" functions for easily locating and navigating
trees of data.
.PP
Mini-XML doesn't do validation or other types of processing
on the data based upon schema files or other sources of
definition information, nor does it support character
entities other than those required by the XML
specification.
.SH USING MINI-XML
Mini-XML provides a single header file which you include:
.nf

    #include <mxml.h>
.fi
.PP
Nodes are defined by the "mxml_node_t" structure; the "type"
member defines the node type (element, integer, opaque,
real, or text) which determines which value you want to look
at in the "value" union.  New nodes can be created using the
"mxmlNewElement()", "mxmlNewInteger()", "mxmlNewOpaque()",
"mxmlNewReal()", and "mxmlNewText()" functions.  Only
elements can have child nodes, and the top node must be an
element, usually "?xml".
.PP
You load an XML file using the "mxmlLoadFile()" function:
.nf

    FILE *fp;
    mxml_node_t *tree;

    fp = fopen("filename.xml", "r");
    tree = mxmlLoadFile(NULL, fp, MXML_NO_CALLBACK);
    fclose(fp);
.fi
.PP
Similarly, you save an XML file using the "mxmlSaveFile()"
function:
.nf

    FILE *fp;
    mxml_node_t *tree;

    fp = fopen("filename.xml", "w");
    mxmlSaveFile(tree, fp, MXML_NO_CALLBACK);
    fclose(fp);
.fi
.PP
The "mxmlLoadString()", "mxmlSaveAllocString()", and
"mxmlSaveString()" functions load XML node trees from and save
XML node trees to strings:
.nf

    char buffer[8192];
    char *ptr;
    mxml_node_t *tree;

    ...
    tree = mxmlLoadString(NULL, buffer, MXML_NO_CALLBACK);

    ...
    mxmlSaveString(tree, buffer, sizeof(buffer),
                   MXML_NO_CALLBACK);

    ...
    ptr = mxmlSaveAllocString(tree, MXML_NO_CALLBACK);
.fi
.PP
You can find a named element/node using the "mxmlFindElement()"
function:
.nf

    mxml_node_t *node = mxmlFindElement(tree, tree, "name",
                                        "attr", "value",
                                        MXML_DESCEND);
.fi
.PP
The "name", "attr", and "value" arguments can be passed as
NULL to act as wildcards, e.g.:
.nf

    /* Find the first "a" element */
    node = mxmlFindElement(tree, tree, "a", NULL, NULL,
                           MXML_DESCEND);

    /* Find the first "a" element with "href" attribute */
    node = mxmlFindElement(tree, tree, "a", "href", NULL,
                           MXML_DESCEND);

    /* Find the first "a" element with "href" to a URL */
    node = mxmlFindElement(tree, tree, "a", "href",
                           "http://www.easysw.com/~mike/mxml/",
                           MXML_DESCEND);

    /* Find the first element with a "src" attribute*/
    node = mxmlFindElement(tree, tree, NULL, "src", NULL,
                           MXML_DESCEND);

    /* Find the first element with a "src" = "foo.jpg" */
    node = mxmlFindElement(tree, tree, NULL, "src",
                           "foo.jpg", MXML_DESCEND);
.fi
.PP
You can also iterate with the same function:
.nf

    mxml_node_t *node;

    for (node = mxmlFindElement(tree, tree, "name", NULL,
                                NULL, MXML_DESCEND);
         node != NULL;
         node = mxmlFindElement(node, tree, "name", NULL,
                                NULL, MXML_DESCEND))
    {
      ... do something ...
    }
.fi
.PP
Finally, once you are done with the XML data, use the
"mxmlDelete()" function to recursively free the memory that
is used for a particular node or the entire tree:
.nf

    mxmlDelete(tree);
.fi
.SH SEE ALSO
mxmldoc(1), Mini-XML Programmers Manual, http://www.easysw.com/~mike/mxml/
.SH COPYRIGHT
Copyright 2003-2007 by Michael Sweet.
